{--------------------------------------------------------}
{
{   Leitor de telas 3.0 - rotinas de parametrizacao do ambiente "vox3"
{   Autores: Jose' Antonio Borges
{            Xyko Goncalves (Serpro)
{
{   Baseado no programa original em assembler de
{       Orlando Jose' Rodrigues Alves
{
{   Em 27/2/97
{
{--------------------------------------------------------}

{$F+}

unit vox3amb;

interface
uses
    dos, crt,
    traduvox, intervox, sintvox, lenumstr, playvox,vox3glob;

procedure ambienta;
procedure FalaErro (erro : integer);

implementation

{----------------------------------------------------------------------}

{*** fala erro ***}

procedure FalaErro (erro : integer);
    var
    chaveErro : string [6];
    listaerro : text;

    begin
    sintsom ('voerro');
    falanumeroconv( numeroparastring(erro),0);
    ok := false;
    str (erro, chaveErro);
    chaveErro := 'ERRO' + chaveErro;
    s := sintambiente ('PGMDOSVOX');
    assign (listaerro, s + '\vox3\vox3amb.err');
    {$i-} reset (listaerro);    {$I+}
    if ioresult <> 0 then
        exit;

    repeat
        readln (listaerro, dados);
        until copy (dados, 1, length (chaveErro)) = chaveErro;
    s := copy (dados, 7, length (dados));
    repeat
        falastring;
        readln (listaerro, dados);
        s := copy (dados, 1, length (dados));
        until copy (dados, 1, 4) = 'ERRO';

    {$i-} close (listaerro); {$i+}
    if ioresult <> 0 then
        begin
        sintsom ('voerro');
        falanumeroconv (numeroparastring (99),0);
        exit;
        end;
    end;



procedure ambienta;
    var
    ambiente : text;
     numjan, erro : integer;

    const
    numeroletra : set of char = ['0'..'9', 'a'..'f'];
    numerofundo : set of char = ['0'..'6'];

    {--------------------------------------------------------}

{ *** funcao para falar numero do erro de inconsistencia do arquivo
ambiente ***}


    {--------------------------------------------------------}

{ *** funcao para formatar janelas ***}

procedure VerJanelas;
    var i : integer;

    begin
    readln (ambiente, dados);  {linha8}
    if copy (dados, 1, 13) <> '*** definicao' then
        begin
        FalaErro (4);
        exit;
end;
    for i := 0 to 9 do
        begin
        readln (ambiente, dados); {linhas 9-18}
        if copy (dados, 1, 6) <> 'janela' then
            begin
            FalaErro (5);
            exit;
            end;
        val (dados [7],  numjan, erro);
        if erro <> 0 then
            begin
            FalaErro (6);
            exit;
            end;
        val (copy (dados, 9, 2), djanelas [i].jay1, erro);
        if erro <> 0 then
            begin
            FalaErro (7);
            exit;
            end;
        val (copy (dados, 11, 2), djanelas [i].jax1, erro);
        if erro <> 0 then
            begin
            FalaErro (7);
            exit;
            end;
        val (copy (dados, 14, 2), djanelas [i].jay2, erro);
        if erro <> 0 then
            begin
            FalaErro (8);
            exit;
end;
        val (copy (dados, 16, 2), djanelas [i].jax2, erro);
        if erro <> 0 then
            begin
            FalaErro (8);
            exit
            end;
    if (djanelas [i] .jay1 > 25) or (djanelas [i] .jay2 > 25) then
        begin
        FalaErro (40);
        exit;
        end;
    if (djanelas [i] .jax1 > 80) or (djanelas [i] .jax2 > 80) then
        begin
        FalaErro (41);
        exit;
        end;
        djanelas [i]. todosc := todosc;
        djanelas [i]. menos := menos;
        if copy (dados, 19, 5) = 'todos' then
            djanelas [i]. todosc := true
        else if copy (dados, 19, 5) = 'menos' then
                begin
                djanelas [i]. todosc := false;
                if (dados [24] = #39) and (length (dados) > 25) and
                        (dados [length (dados)] = #39) then
                    djanelas [i]. menos := copy (dados, 25, (length (dados) -25))
                else begin
                    FalaErro (47);
                    exit;
                    end;
                end
            else if length (dados) > 18 then
                    begin
                    FalaErro (44);
                    exit;
                    end;
        end;
    end;

{------------------------------------------------------}

{*** funcao para formatar marcas ***}

procedure VerMarcas;
    var c : char;

    begin
    readln (ambiente, dados); {linha20}
    if copy (dados, 1, 10) <> '*** marcas' then
        begin
        FalaErro (13);
        exit;
        end;
    for c:= 'A' to 'Z' do
        begin
        readln (ambiente, dados);  {linha 21-46}
        if copy (dados, 1, 6) <> 'marca-' then
            begin
            FalaErro (14);
            exit;
            end;
        if (ord (upcase (dados [7])) < 65) and
                 (ord (upcase (dados [7])) > 90) then
            begin
            FalaErro (15);
            exit;
            end;
        val (copy (dados, 9, 2), marcas [c] .plinha, erro);
        if erro <> 0 then
            begin
            FalaErro (16);
            exit;
            end;
        val (copy (dados, 11, 2), marcas [c] .pcoluna, erro);
        if erro <> 0 then
            begin
            FalaErro (17);
            exit;
            end;
        if marcas [c] .plinha > 25 then
            begin
        FalaErro (42);
            exit
            end;
        if marcas [c] .pcoluna > 80 then
            begin
        FalaErro (43);
            exit;
            end;
        end;
    end;

{------------------------------------------------------}

{*** funcao para parametrizar monitoracao ***}

procedure VerMonitoracao;
    begin
    readln (ambiente, dados);  {linha48}
    if copy (dados, 1, 17) <> '*** procedimentos' then
        begin
        FalaErro (18);
        exit;
        end;
    readln (ambiente, dados); {linha49}
    if copy (dados, 1, 12) <> 'monitorando=' then
        begin
        FalaErro (19);
        exit;
        end;
    monitora. plinha := 0;
    monitora. pcoluna := 0;
    val (copy (dados, 13, 2), monitora .plinha, erro);
    if erro <> 0 then
        begin
        FalaErro (20);
        exit;
        end;
    val (copy (dados, 15, 2), monitora. pcoluna, erro);
    if erro <> 0 then
        begin
        FalaErro (21);
        exit;
        end;
    if monitora .plinha > 25 then
        begin
        FalaErro (45);
        exit;
        end;
    if monitora .pcoluna > 80 then
        begin
        FalaErro (46);
        exit;
        end;

    readln (ambiente, dados);  {linha50}
    if copy ( dados, 1, 9) <> 'verifica=' then
        begin
        FalaErro (22);
        exit;
        end;
    if upcase (dados [10]) = 'Q' then
        monitora. ver :=  'Q'
    else if upcase ( dados [10]) = 'D' then
            begin
            monitora . ver := 'D';
            monitora. car := upcase (dados [11]);
            end
        else if upcase (dados [10]) = 'I' then
                begin
                monitora . ver := 'I';
                monitora. car := upcase (dados [11]);
                end
            else begin
                FalaErro (23);
                exit;
                end;
    readln (ambiente, dados); {linha51}
    if copy (dados, 1, 5) <> 'acao=' then
        begin
        FalaErro (24);
        exit;
        end;
    if copy (dados, 6,2) = 'ja' then
        begin
        monitora. acao := 'j';
        val (dados [8], monitora. jan, erro);
        if erro <> 0 then
            begin
            FalaErro (25);
            exit;
            end;
        if (djanelas [monitora. jan]. jay1 = 0) or
            (djanelas [monitora. jan]. jax1 = 0) or
            (djanelas [monitora. jan]. jay2 = 0) or
            (djanelas [monitora. jan]. jax2 = 0) then
            begin
            FalaErro (34);
            exit;
            end;
        end
    else if copy (dados, 6,3) = 'msg' then
        begin
            monitora. acao := 'm';
            if (dados [9] = #39) and (length (dados) > 10) and
                    (dados [length (dados)] = #39) then
                monitora. msg := copy (dados, 10, (length (dados) -10))
            else begin
                FalaErro (33);
                exit;
                end;
            end
        else begin
            FalaErro (32);
            ok := false;
            exit;
            end;
    end;

{------------------------------------------------------}

{*** funcao para obter cor de letra ***}

procedure VerCorLetra;
    var i : integer;

    begin
    readln (ambiente, dados); {linha53}
    if copy (dados, 1, 17) <> '*** especificacao' then
        begin
        FalaErro (26);
        exit;
        end;
    for i := 0 to 15 do
        begin
readln (ambiente, dados);  {linha54-68}
        if not (dados [2] in numeroletra) then
            begin
            FalaErro (27);
            exit;
            end;
        if copy (dados, 4, 3) = 'sim' then
            begin
            temletra := true;
            corletra := i;
            end
        else if copy (dados, 4, 3) <> 'nao' then
                begin
                FalaErro (28);
                exit;
                end;
        end;
    end;

{------------------------------------------------------}

{*** funcao para obter cor de rfundo ***}

procedure VerCorFundo;
    var i : byte;

    begin
    readln (ambiente, dados);  {linha71}
    if copy (dados, 1, 17) <> '*** especificacao' then
        begin
        FalaErro (29);
        exit;
        end;
    for i := 0 to 6 do
        begin
readln (ambiente, dados);  {linha72-77}
        if not (dados [2] in numerofundo) then
            begin
            FalaErro (30);
            exit;
            end;
        if copy (dados, 4, 3) = 'sim' then
            begin
            temfundo := true;
            corfundo := i;
            end
        else if copy (dados, 4, 3) <> 'nao' then
            begin
            FalaErro (31);
            exit;
            end;
        end;
    end;

{------------------------------------------------------}

{*** funcao para controlar a leitura do arquivo ambiente ***}

procedure LeAmbiente;
    begin
    ok := true;
    temletra := false;
    temfundo := false;
    {$i-} reset (ambiente);    {$I+}
    if ioresult <> 0 then
        begin
        FalaErro (1);
        exit;
        end;
    readln (ambiente, dados);  {linha1}

    if copy (dados, 1, 14) <> '*** parametros' then
        begin
        FalaErro (2);
        exit;
        end;
    readln (ambiente, dados);  {linha2}
    if copy (dados, 1, 11) <> 'velocidade=' then
        begin
        FalaErro (37);
        exit;
        end;

    veloAtual := dados[12];
{
    case veloAtual of
    '1': begin
            falaRapida (false);
            falacondensada (false);
         end;
    '2': begin
            falaRapida (true);
            falacondensada (false);
         end;
    '3': begin
            falacondensada (true);
            falarapida (false);
         end;
    '4': begin
            falaRapida (true);
            falacondensada (true);
         end;
    else
         veloAtual := '3';
         FalaErro (38);
         exit;
    end;
}

    if (veloAtual < '1') or (veloAtual > '4') then
         begin
         FalaErro (38);
         exit;
         end;

    tradFim;
    selecTipoFonemas (ord (veloAtual) - ord ('0'));
    if tradInic <> 0 then
        begin
            tradFim;
            selecTipoFonemas (0);
            if tradInic <> 0 then;
        end;

    falaRapida (veloAtual = '4');



    menos := '';
    readln (ambiente, dados);  {linha3}
    if copy (dados, 1, 14) = 'falatela=todos' then
        todosc := true
    else if copy (dados, 1, 14) = 'falatela=menos' then
            begin
            todosc := false;
            if (dados [15] = #39) and (length (dados) > 16) and
                    (dados [length (dados)] = #39) then
                menos := copy (dados, 16, (length (dados) -16))
            else begin
                FalaErro (39);
                exit;
                end;
            end
        else begin
            FalaErro (3);
            exit;
            end;
    salvatodosc := todosc;
    janelatodosc := todosc;
    salvamenos := menos;
    janelamenos := menos;

    readln (ambiente, dados);  {linha4}
    if copy (dados, 1, 6) <> 'notas=' then
        begin
        FalaErro (9);
        exit;
        end;
    if length (dados) < 7 then
        begin
            FalaErro (12);
            exit;
            end;
    linhas := copy (dados, 7, length (dados));

    readln (ambiente, dados);  {linha5}
    if (copy (dados, 1, 9) <> 'converte=') then
        begin
        FalaErro (11);
        exit;
        end;
    if copy (dados, 10, 4) = 'ansi' then
        ansi := true
    else if copy (dados, 10, 2) = 'pc' then
   ansi := false
        else begin
            FalaErro (11);
            exit;
            end;
    readln (ambiente, dados);  {linha6}
    if copy (dados, 1, 14) <> 'delimitabarra=' then
        begin
        FalaErro (49);
        exit;
        end;
    val (copy (dados, 15, 17), delibarra, erro);
    if erro <> 0 then
        begin
        FalaErro (50);
        exit;
        end;

    readln (ambiente, dados);  {linha7}
    VerJanelas;
    if not ok then exit;

    readln (ambiente, dados);  {linha19}
    VerMarcas;
    if not ok then exit;

    readln (ambiente, dados); {linha47}
    VerMonitoracao;
    if not ok then exit;

    readln (ambiente, dados); {linha52}
    VerCorLetra;
    if not ok then exit;

    readln (ambiente, dados);  {linha70}
    VerCorFundo;
    end;


{------------------------------------------------------}

{*** gera ambiente padrao "vox3" ***}

procedure ambientepadrao;
    var
    c : char;
    i : integer;

    begin
    falaRapida (false);
    todosc := (true);
    djanelas [0]. jay1 := 1;
    djanelas [0]. jax1 := 1;
    djanelas [0]. jay2 := 25;
    djanelas [0]. jax2 := 80;

    for i := 1 to 9 do
        begin
        djanelas [i]. jay1 := 0;
        djanelas [i]. jax1 := 0;
        djanelas [i]. jay2 := 0;
        djanelas [i]. jax2 := 0;
        end;
    i := 1;
    for c := 'A' to 'Z' do
        begin
        marcas [c]. plinha := i;
        inc (i);
        marcas [c]. pcoluna := 1;
        end;
    temletra := false;
    temfundo := false;
    monitora. plinha := 0;
    monitora. pcoluna := 0;
    end;

{------------------------------------------------------}

{*** inicio ambienta ***}

    begin
    pegabasehard;
    assign (ambiente, novoarq);
    LeAmbiente;
    {$i-} close (ambiente); {$i+}
    if ioresult <> 0 then
        exit;
    if not ok then
AmbientePadrao;
    tradfim;
    end;

end.
