{--------------------------------------------------------}
{
{   Leitor de telas 3.0
{
{   Autores: Jose' Antonio Borges
{            Xyko Goncalves (Serpro)
{            Marcelo Pimentel
{
{   Baseado no programa original em assembler de
{       Orlando Jose' Rodrigues Alves
{
{   Em 14/1/97
{
{--------------------------------------------------------}

{$M 20000,40000,40000}
program vox3;
uses
    dos, crt,
    traduvox, intervox, sintvox, vox3func;

const
    tambuf = 2048;
    LF = $0a;
var
    intTecOrig: procedure;
    intDosIdleOrig: procedure;
    int8Original: procedure;

    quantTimer: byte;

    dosOcup: ^byte;
    codFunc1, codFunc2: char;

    segStackNova, stackPtrNova: word;
    regs: registers;

    statusVox: (INATIVO, PENDENTE, ATIVO);

{$F+}

{--------------------------------------------------------}
{                       ativa o vox
{--------------------------------------------------------}

procedure ativaVox;

begin
    statusVox := ATIVO;
    asm              { interrupcoes estao inibidas }
        mov ax,ss
        mov bx,sp

        mov ss,segStackNova
        mov sp,stackPtrNova

        push ax  {salva ss e sp}
        push bx
    end;

    asm sti; end;    { libera interrupcoes }
    if (codFunc1 = #0) and (codFunc2 = #0) then
        ativaLedor
    else
        ativaImediato (codFunc1, codFunc2);

    asm
        pop ax   {pega sp e ss salvo}
        pop ss
        mov sp,ax
    end;

    statusVox := INATIVO;
end;

{--------------------------------------------------------}
{                nova interrupcao de teclado
{--------------------------------------------------------}

procedure novaIntTec; interrupt;

var regs: registers;
    acionou, imediato: boolean;

const 
      SHIFT   = 2;
      CONTROL = 4;
      ALT     = 8;

begin
    asm; pushf; end;
    intTecOrig;

    asm; sti; end;    { libera interrupcoes }

    regs.ah := 2;
    intr ($16, regs);

    acionou := regs.al and (CONTROL+ALT) = (CONTROL+ALT);
    if acionou then
        begin
            codFunc1 := #0;
            codFunc2 := #0;
        end
    else
        begin
            imediato := regs.al and (CONTROL+SHIFT) = (CONTROL+SHIFT);
            if imediato then
                begin
                    if keypressed then
                        begin
                            acionou := true;
                            codFunc1 := readkey;
                            if keypressed then
                                codFunc2 := readkey;
                        end;
                end;
        end;

    asm; cli; end;    { inibe interrupcoes }

    if statusVox <> ATIVO then
        begin
            if acionou then
                if dosOcup^ = 0 then
                    ativaVox
                else
                    statusVox := PENDENTE;
        end;

    asm; sti; end;    { libera interrupcoes }
end;

{--------------------------------------------------------}
{                nova interrupcao de Dos Idle
{--------------------------------------------------------}

procedure novaDosIdle; interrupt;
begin
    asm pushf; end;
    intDosIdleOrig;

    asm cli; end;    { inibe interrupcoes }

    if statusVox = PENDENTE then
        ativaVox;

    asm sti; end;    { libera Interrupcoes }
end;

{--------------------------------------------------------}
{                nova interrupcao do timer
{--------------------------------------------------------}

{$f+}
procedure novaIntTimer; interrupt;
var
    regs: registers;

begin
    asm; pushf; end;
    int8Original;
    port [$20] := $20;

    if statusVox = PENDENTE then
        begin
            quantTimer := quantTimer + 1;

            if quantTimer >= 9 then
                begin
                    if dosOcup^ = 0 then
                        begin
                            asm pushf; end;
                            intDosIdleOrig;
                        end;

                    quantTimer := 0;
                end;
        end;
end;

{--------------------------------------------------------}
{                       ativa o vox
{--------------------------------------------------------}

begin
    statusVox := INATIVO;
    quantTimer := 0;

    regs.ah := $34;          { pega endereco de Dos Busy }
    intr ($21, regs);
    dosOcup := ptr (regs.es, regs.bx);

    segStackNova := SSeg;
    stackPtrNova := SPtr;

    asm cli; end;

    GetIntVec (  9, @IntTecOrig);       { substitui interrupcao de teclado }
    SetIntVec (  9, addr (novaIntTec));

    GetIntVec ($28, @IntDosIdleOrig);   { substitui interrupcao Dos Idle }
    SetIntVec ($28, addr (novaDosIdle));

    if (paramcount = 0) then
      begin
        getIntVec (8, @Int8Original);  { substitui interrupcao de timer }
        setIntVec (8, addr (novaIntTimer));
      end;

    asm sti; end;

    inicLedor;
    keep (0);
end.
