{--------------------------------------------------------}
{   Leitor de telas 3.0 - rotinas de ativacao de funcoes
{
{   Autores: Jose' Antonio Borges
{            Xyko Goncalves (Serpro)
{
{   Baseado no programa original em assembler de
{       Orlando Jose' Rodrigues Alves
{
{   Em 14/1/97
{
{--------------------------------------------------------}

{$F+}

unit vox3func;

interface
uses
    dos, crt,
    traduvox, intervox, sintvox, lenumstr, playvox,
    vox3amb, vox3glob, vox3jan, vox3str, vox3mon;

procedure inicLedor;
procedure ativaLedor;
procedure ativaImediato (c1, c2: char);

implementation

{--------------------------------------------------------}

{***  inicializacao do ambiente "vox3" ***}

procedure inicLedor;
var s: string;
begin
    sintinic (0, 'DIRVOX3');
    if tradinic <> 0 then
        begin
            sintbip; sintbip;
            writeln ('Erro no diretorio do tradutor !');
            exit;
        end;

                        sound (440); delay (80); nosound; delay (30);
                        sound (530); delay (80); nosound; delay (30);
    sound (780); delay (300);
    nosound;
    clrscr;
    textbackground (BLUE);
    writeln ('*   *   ***   *   *  **** ');
    writeln ('*   *  *   *   * *       *');
    writeln ('*   *  *   *    *        *');
    writeln (' * *   *   *    *     *** ');
    writeln (' * *   *   *    *        *');
    writeln ('  *    *   *   * *       *');
    writeln ('  *     ***   *   *  **** ');
    writeln;
    textBackground (RED);
    writeln ('SERPRO (SERVIO FEDERAL DE PROCESSAMENTO DE DADOS)');
    writeln;
    writeln ('NCE (NCLEO DE COMPUTAO ELETRNICA DA UFRJ)');
    textbackground (BLACK);
    clreol;

    sintsom ('vodos');
    s := sintAmbiente ('PGMDOSVOX');
    novoarq := s + '\vox3\vox3.amb';
    ambienta;
    {$i- close (ambiente); {$i+}
    if ioresult <> 0 then
        exit;
    if (ok) and (monitora. ver = 'q') then
        monitora. car := letela (monitora. plinha, monitora. pcoluna);

    tradfim;
end;

{--------------------------------------------------------}

{***                   le a tela com o cursor ***}

procedure ativaLedor;

{------------------------------------------------------}

{ *** funcao para falar cor da letra e fundo da   posicao da tela *** }

procedure falacor (linha, coluna : integer);
Const
   TabCores: Array [0..15]of String[8]=
        ('vopreto', 'voazul', 'voverde', 'vociano', 'vovermel',
         'vomagent', 'vomarron', 'vocinzac', 'vocinzae', 'voazulc', 'voverdec',
         'vocianoc', 'vovermec', 'vomagenc', 'voamarel', 'vobranco');

var
    caracter : string[3];
    corLetra, corFundo: byte;
    piscante: boolean;

    begin
        corLetra := leatrib (linha, coluna) and $f;
        corFundo := (leatrib (linha, coluna) shr 4) and 7;
        piscante := (leatrib (linha, coluna) and $80) <> 0;

        sintsom (tabcores [corLetra]);
        sintsom ('VOFUNDO');
        sintsom (tabcores [corFundo]);
        if piscante then sintsom ('VOPISCAN');
    end;

    {------------#--------------------------------------------}

{ *** funcao para enderear um ponto na tela *** }

procedure irpara;
    var
    c : char;
    numealfa :string[2];
    numlinha, numcoluna, posc, i : integer;

    begin
    sintsom ('voirpara');
    numealfa := '';
    numlinha := 0;
    numcoluna := 0;
    i := 1;
    repeat
        regs.ax := 0;
        intr ($16, regs);
        c := chr (regs.ax and $ff);
        case c of
        #$0: sintsom ('votecinv');
        'A'..'Z', 'a'..'z' : begin
            sintcarac (c);
            if (numealfa <> '') and (numlinha = 0) then
                begin
                sintsom ('voerroli');
                exit;
                end
            else if (numealfa <> '') and (numcoluna = 0) then
                    begin
                    sintsom ('voerroco');
                    exit;
                    end
                else if (numealfa = '') and (numlinha > 0) then
                        begin
                        sintsom ('voerroco');
                        exit;
                        end;
            c := upcase (c);
            linha := marcas[c] .plinha;
            coluna := marcas[c] .pcoluna;
            exit;
            end;
        '0'..'9' : begin
            sintcarac (c);
            numealfa :=numealfa + c;
            inc (i);
            end;
        ',' : begin
            sintcarac (c);
            val (numealfa, numlinha, posc);
            numealfa := '';
            if numlinha > 25 then
                numlinha := 25;
            inc (i);
            linha := numlinha;
            end;
        end;
    until (c = #13) or (c = #32) or (i > 5);
    if (numlinha > 0) and (numealfa <> '') then
        begin
        val (numealfa, numcoluna, posc);
        if numcoluna > 80 then
            numcoluna := 80;
        coluna := numcoluna;
        end
    else if (numlinha = 0) and (numealfa <> '') then
        begin
        val (numealfa, numlinha, posc);
        if numlinha > 25 then
            numlinha := 25;
        linha := numlinha;
        end;
    end;

    {-----------------#------------------------------#---------}

{ *** funcao para procurar um caracter na tela *** }

procedure procuracaracter;
var
    c, letra : char;
    llinha, ccoluna : integer;

    begin
    sintsom ('voprocur');

    regs.ax := 0;
    intr ($16, regs);
    c := chr (regs.ax and $ff);

    sintcarac (c);
    ilinha := janpy1;
    flinha := janpy2;
    icoluna := janpx1;
    fcoluna := janpx2;
    if linha > ilinha then
        ilinha := linha;
    if coluna > icoluna then
        icoluna := coluna;
    for llinha := ilinha to flinha do
        for ccoluna := icoluna to fcoluna do
            begin
            letra := letela (llinha, ccoluna);
            if c = letra then
                begin
                sintsom ('voaqui');
                linha := llinha;
                coluna := ccoluna;
                exit;
                end;
        end;
    sintsom ('vonaotem');
    end;


    {--------------------------------------------------------}

{ *** funcao para procurar palavra a direita ***}

procedure palavradireita (procuratela : boolean);
    label pulabranco;

    begin
    while (letela (linha, coluna) <> ' ') and (coluna < (janpx2 +1)) do
        inc (coluna);
PulaBranco :
    while (letela (linha, coluna) = ' ') and (coluna < (janpx2 +1)) do
        inc (coluna);
    if coluna > janpx2 then
        if (linha < janpy2) and (procuratela) then
            begin
            sintbip;
            inc (linha);
            coluna := janpx1;
            goto PulaBranco;
            end
        else begin
        coluna := janpx2;
        sintbip;
        end;
    end;

    {--------------------------------------------------------}

{ *** funcao para procurar palavra a esquerda *** }

procedure palavraesquerda (procuratela : boolean);
label PulaBranco;

    begin
    PulaBranco:
    dec (coluna);
    if coluna <= (janpx1 -1) then
        if linha > janpy1 then
            begin
            sintbip;
            dec (linha);
            coluna := janpx2;
            end
        else begin
            sintbip;
            coluna := janpx1;
            exit;
            end;
    while (letela (linha, coluna) = ' ') and (coluna > (janpx1 -1)) do
        dec (coluna);
    while (letela (linha, coluna) <> ' ') and (coluna > (janpx1 -1)) do
        dec (coluna);
    if (coluna = (janpx1 -1)) and (letela (linha, janpx1) = ' ') and
                (procuratela) then
                goto PulaBranco;

    inc (coluna);
    end;

{-----------------------------------------------------}

{ *** funcao para marcar um desvio  *** }

procedure poemarca;
    label novamarca;

    begin
    sintsom ('vomarcal');
novamarca:
    regs.ax := 0;
    intr ($16, regs);
    c3 := upcase (chr (regs.ax and $ff));
    case c3 of
        #0 : begin
            sintsom ('votecinv');
            goto novamarca;
            end;
            esc : begin
                sintsom ('voanulad');
                exit;
                end;
        #1..#64, #91..#255 : begin
                sintsom ('votecinv');
                goto novamarca;
                end;
        end;
    sintcarac (c3);
    marcas [c3] .plinha := linha;
    marcas [c3] .pcoluna := coluna;
    end;

    {--------------------------------------------------------}

{ *** funcao para procurar um string na tela *** }

procedure ProcuraString;
    var
    llinha, ccoluna, posp, pospril1 : integer;
    palavra, todalinha : string[80];

    begin
    pospril1 := 0;
    sintsom ('voprocur');
    palavra := leteclado;
    if c3 = esc then
        exit;
    if (c3 = #13) and (palavra = '') then
        begin
        palavra := palavraant;
        if (linha >= liant) and (coluna >= coant)
                and ((coluna + length (palavra)) < 80) then
            coluna := coluna + length (palavra);
        end;
    ilinha := janpy1;
    flinha := janpy2;
    icoluna := janpx1;
    fcoluna := janpx2;
    if linha > ilinha then
        ilinha := linha;
    if coluna > icoluna then
        begin
        icoluna := coluna;
        pospril1 := coluna - 1;
        end;
    for llinha := ilinha to flinha do
        begin
        todalinha := '';
        for ccoluna := icoluna to fcoluna do
            todalinha := todalinha + letela (llinha, ccoluna);
        icoluna := janpx1;
        palavra := maiuscansi (palavra);
        todalinha := maiuscansi (todalinha);
        posp := pos (palavra, todalinha);
        if  posp > 0 then
            begin
            sintsom ('voaqui');
            linha :=llinha;
            coluna :=posp + pospril1 + (janpx1 -1);
            liant := linha;
            coant := coluna;
            palavraant := palavra;
            exit;
            end;
        pospril1 := 0;
        end;
    sintsom ('vonaotem');
    palavraant := palavra;
    end;

    {--------------------------------------------------------}

    function alfanum (c: char): boolean;
    begin
        alfanum := (c in ['a'..'z','','','','','','',''])
                   or
                   (c in  ['','','','',''])
                   or
                   (c in ['0'..'9'])
                   or
                   (c in ['A'..'Z','','','','','']);
    end;

{------------------------------------------------------}

{*** funcao para guardar uma linha num arquivo "ascii" ***}

procedure GuardaLinha;
    var
    i : integer;
    linguardada : text;

    begin
    s := '';
    if linha <= janpy2 then
        begin
        for i := 1 to 81 do
            s := s + letela (linha, i);
        inc (linha);
        end
    else sintbip;

    if s <> '' then
        begin
        assign (linguardada, linhas);
        {$i-} append (linguardada); {$i+}
        if ioresult <> 0 then
            begin
            {$i-} rewrite (linguardada); {$i+}
            if ioresult <> 0 then
                begin
                FalaErro (91);
                exit;
                end;
            end;
        writeln (linguardada, s);
         close (linguardada);
        sintclek;
        end;
    end;

    {--------------------------------------------------------}

    procedure posUltColuna;
    begin
        coluna := 81;
        repeat
            coluna := coluna - 1;
        until (coluna < 1) or (letela (linha, coluna) <> ' ');
        coluna := coluna + 1;

        if coluna < 1 then
           sintClek;
    end;

    {-----------------------------------------------------#---}

    procedure falaPalavra;
    var c: char;
    begin
        s := '';
        repeat
            c := letela (linha, coluna);
            if (c = ' ') and (coluna < 80) then
                coluna := coluna + 1;
        until (c <> ' ') or (coluna >= 80);

        if coluna >= 80 then exit;

        repeat
            gotoxy (coluna, linha);
            s := s + c;
            coluna := coluna + 1;

           c := letela (linha, coluna);

        until (not alfanum(c)) or (coluna > 80);

        if length (s) = 1 then
            begin
                if ord (s[1]) > 165 then
                    sintClek
                else
                    sintCarac (s[1]);
            end
        else
            begin
                fala (s);

            end;
    end;

    {--------------------------------------------------------}

    procedure delimitaCampo (var col1, col2: integer);
    const
        DELIMCAMPO: set of char = ['!', '?', ':', '|', #176..#223];
    var atrib: byte;
    begin
        atrib := leAtrib (linha, coluna);

        col1 := coluna+1;
        repeat
            col1 := col1 - 1;
        until (col1 < 1) or
              (leAtrib (linha, col1) <> atrib) or
              (leTela (linha, col1) in DELIMCAMPO);
        col1 := col1 + 1;
        col2 := coluna-1;

        repeat
            col2 := col2 +1;
        until (col2 > 80) or
              (leAtrib (linha, col2) <> atrib) or
              (leTela (linha, col2) in DELIMCAMPO);
        col2 := col2 - 1;
    end;

    {-----------#-------------------------------------#--------}

    procedure posCampoAnt;
    begin
        delimitaCampo (col1, col2);
        coluna := col1 - 2;
        sintClek;
    end;

    {--------------------------------------------------------}

{*** le todalinha com seta para cima ***}

procedure lelinhacima;
    begin
    dec (linha);
    if linha > (janpy1 -1) then
        begin
        gotoxy (coluna, linha);
        salvacoluna := coluna;
        coluna :=janpx1;
        lerestolinha (janpx2);
        coluna := salvacoluna;
        end
    else begin
        linha :=janpy1;
        sintbip;
        end;
    end;

    {--------------------------------------------------------}

{*** volta tela e cursor para aplicacao ***}

procedure VoltaCursor;
begin
    if formatada then
        begin
        formatada := false;
        janpy1 := salvay1;
        janpx1 := salvax1;
        janpy2 := salvay2;
        janpx2 := salvax2;
        move (salvamem, mem [basehard : 0], 4000);
        todosc := janelatodosc;
        menos := janelamenos;
        end;
    linha := salvay;
    coluna := salvax;
    if upcase (cz) = 'V' then
        begin
        janelamenos := salvamenos;
        menos := salvamenos;
        todosc := salvatodosc;
        janelatodosc := salvatodosc;
        janpy1 := 1;
        janpx1 := 1;
        janpy2 := 25;
        janpx2 := 80;
        end;
    end;

    {--------------------------------------------------------}

{*** le linha com seta para baixo ***}

procedure lelinhabaixo;
    begin
    inc (linha);
    if linha < (janpy2 +1) then
        begin
        gotoxy (coluna, linha);
        salvacoluna := coluna;
        coluna :=janpx1;
        lerestolinha (janpx2);
        coluna := salvacoluna;
        end
    else begin
        linha := janpy2;
        sintbip;
        end;
    end;

{------------------------------------------------------}

{*** funcao para marcar janela para o modo "ledor" ***}

procedure MarcaJanela;
    var
    i : integer;

    begin
    ObtemJanela (i);
    if c3 = esc then
        exit;
    todosc := djanelas [i]. todosc;
    janelaTodosc := djanelas [i]. todosc;
    menos := djanelas [i]. menos;
    janelamenos := djanelas [i]. menos;
    janpy1 := djanelas [i].jay1;
    janpx1 := djanelas [i]. jax1;
    janpy2 := djanelas [i]. jay2;
    janpx2 := djanelas [i]. jax2;
    if linha < janpy1 then
        linha := janpy1;
    if coluna < janpx1 then
        coluna := janpx1;
    if linha > janpy2 then
        linha := janpy2;
    if coluna > janpx2 then
        coluna := janpx2;
    end;

    {----------------------------------------------#----------}

    procedure ignoraTeclas;
    var c: char;
    begin
        while keypressed do
            begin
                regs.ax := 0;
                intr ($16, regs);
                c := chr (regs.ax and $ff);
            end;
    end;

{------------------------------------------------------}

{***  funcao para fazer leitura de cursores fsico e lgico ***}

procedure FalaCursores;
    begin
    if upcase (cz) = 'I' then
        begin
        falanumeroconv (numeroparastring (salvay),0);
        falanumeroconv (numeroparastring (salvax),0);
        c := ' ';
        end
    else begin
        falanumeroconv (numeroparastring (wherey),0);
        falanumeroconv (numeroparastring (wherex),0);
        end;
    end;

    {------#-----------------#-----------------#----------------}

{*** inicio leiatela ***}

label fim, erro, LeuCarac;

begin
    sintInic (0, 'DIRVOX3');
    if tradinic <> 0 then
        begin
            sintbip; sintbip;
            exit;
        end;

    linha  := wherey;
    coluna := wherex;
    salvax := coluna;
    salvay := linha;

    sintsom ('voledor');
    c := ' ';
    todosc := janelaTodosc;
    menos := janelaMenos;
    AjustaCursor;

    repeat
        gotoxy (coluna, linha);

        cz := c;
        c2 := ' ';
        regs.ax := 0;
        intr ($16, regs);
        c  := chr (regs.ax and $ff);
        c2 := chr (regs.ax shr 8);

  LeuCarac :
        case c of
            #13, esc :  ;

            'a', 'A' : begin
                sintsom ('voascii');
                falanumeroconv( numeroparastring(ord
                    (letela (linha, coluna))), 0);
                end;
            'H', 'h' : FalaDataHora;
            'I', 'i' : FalaCursores;
            'b', 'B' : begin
            coluna := janpx1;
            linha := janpy2;
            sintclek;
            end;
            't', 'T' : begin
            if upcase (cz) <> 'T' then
                begin
                linha := janpy1;
                coluna :=janpx1;
                sintclek;
                end
            else begin
                c := ' ';
                dec (linha);
                repeat
                inc (linha);
                coluna := janpx1;
                LeRestoLinha (janpx2);
                gotoxy (coluna, linha);
                until (linha > janpy2) or (keypressed);
                end;
            end;

            'V', 'v' :  begin
                VoltaCursor;
                sintclek;
                end;

        'k', 'K' : CapturaCarater;

            'l', 'L' :  begin
            LerestoLinha (janpx2);
            if keypressed then
                begin
                cz := c;
                regs.ax := 0;
                intr ($16, regs);
                c  := chr (regs.ax and $ff);
                if UpCase(C) = 'L'  Then
                    begin
                    If linha < janpy2  Then
                        begin
                        inc (linha);
                        coluna := janpx1;
                        gotoxy (coluna, linha);
                        goto LeuCarac
                        end
                    else begin
                        sintbip;
                        gotoxy (coluna, linha);
                        goto LeuCarac;
                        end;
                    end
                else begin
                    gotoxy (coluna, linha);
                    goto LeuCarac;
                    end;
                end
            else if linha < janpy2 then
                begin
                coluna := janpx1;
                inc (linha)
                end
                else begin
                    sintbip;
                    coluna := janpx1;
                    gotoxy (coluna, linha);
                    end;
            end;

            #12 : begin
                dec (linha);
                repeat
                inc (linha);
                coluna := janpx1;
                LeRestoLinha (janpx2);
                gotoxy (coluna, linha);
                until (linha > janpy2) or (keypressed);
                end;

            'r', 'R' : begin
PalavraDireita (true);
            palavraatual (linha, coluna, 80);
            end;
            'E', 'e' : palavraatual (linha, coluna, 80);
            'W', 'w' : begin
            palavraesquerda (true);
            palavraatual (linha, coluna, 80);
            end;

            'q', 'Q' : FalaCor (linha, coluna);

            's', 'S' : begin
            sintclek;
            coluna := janpx1;
            end;
            'c', 'C' : begin
                sintcarac (letela (linha, coluna));
                inc (coluna);
                if coluna > janpx2 then
                    begin
                    dec (coluna);
                    if upcase (cz) = 'C' then
                        sintbip;
                    end
                else c := ' ';
                  end;

            'x', 'X' : falanumeroconv (numeroparastring (wherex), 0);
            'y', 'Y' : falanumeroconv (numeroparastring (wherey), 0);
            'g', 'G' : irpara;
            'd', 'D' : if linha < janpy2 then
                begin
                inc (linha);
                sintclek;
                end
            else sintbip;
            'u', 'U' : if linha > janpy1 then
                begin
                dec (linha);
                sintclek;
                end
            else sintbip;
            'z', 'Z' : begin
                if (upcase (cz) <> 'Z') and (coluna > 1) then
                    dec (coluna);
                FalaFonetica (letela (linha, coluna));
                inc (coluna);
                end;
            'M', 'm' : poemarca;
            'f', 'F' : procuracaracter;
            '/' : ProcuraString;
            'J', 'j' : MarcaJanela;
            'P', 'p' : GuardaLinha;

            #$0: case c2 of
                     CIMA:  lelinhacima;

                     BAIX: lelinhabaixo;

                     ESQ: FalaEsq;
                     DIR: FalaDir;

                    CTLESQ: begin
                        PalavraEsquerda (false);
                        sintclek;
                        end;
                     CTLDIR: begin
                        PalavraDireita (false);
                        sintclek;
                    end;
                     BKTAB:  posCampoAnt;

                     HOME:   coluna := 1;
                     TEND:   posUltColuna;


                    f5 : ProcuraString;
                    F1:     begin
                                  falaPalavra;
                                  if coluna >= janpx2 then
                                      begin
                                         sintClek;
                                         posUltColuna;
                                      end;
                             end;

                    f2 : guardajanela (linha, coluna);

                    f3 : RecuperaJanela;

                     CTLF1:  begin
                            dec (linha);
                            lelinhabaixo;
                            coluna := janpx1;
                            end;

                 else
                     goto erro;
                     end

        else
            begin
erro:
    sintsom ('votecinv');
            end;
        end;

        if coluna < 1 then
            begin  sintBip;  ignoraTeclas; coluna := 1;  end;
        if coluna > 81 then
            begin  sintBip;  ignoraTeclas; coluna := 80;  end;
        if linha < 1 then
            begin  sintBip;  ignoraTeclas; linha := 1;  end;
        if linha > 25 then
            begin  sintBip;  ignoraTeclas; linha := 25;  end;

    until (c = #$1b) or (c = #13);

fim:
    VoltaCursor;
    todosc := salvatodosc;
menos := salvamenos;
    sintsom ('vodos');
    tradfim;

    gotoxy (salvax, salvay);
end;

{--------------------------------------------------------}
{                     ledor imediato
{--------------------------------------------------------}

procedure ativaImediato (c1, c2: char);
    var
lc : char;

{------------------------------------------------------}

{***  funcao para fazer leitura imediata da posicao do cursor ***}

procedure EndCursorImediato;
    begin
    falanumeroconv (numeroparastring (wherey),0);
    falanumeroconv (numeroparastring (wherex),0);
    end;

{--------------------------------------------------------}

{*** funcao para pedir novo arquivo ambiente ***}

procedure NovoAmbiente;
    var i: integer;
        s: string;
    begin
    sintsom ('voambien');
        novoarq := leteclado;
    if c3 = esc then
        exit;
    s := copy (novoarq, (length (novoarq) - 3), length (novoarq));
    s := maiuscansi (s);
    if s<> '.AMB' then
        novoarq := novoarq + '.AMB';
    i := length (novoarq);
    while (novoarq [i] <> '\') and (i > 0) do
        dec (i);
    if i > 0 then
        novoarq := copy (novoarq, (i +1), length (novoarq));
    s := sintAmbiente ('PGMDOSVOX');
    novoarq := s + '\vox3\' + novoarq;
    ambienta;
    janpy1 := 1;
    janpy2 := 25;
    janpx1 := 1;
    janpx2  := 80;
    janl1 := 1;
    janl2 := 80;
    sintclek;
    end;

{--------------------------------------------------------}

{*** funcao para controlar a largura da tela***}

procedure LarguraTela;
    var
    i : integer;

    begin
    ObtemJanela (i);
    if c3 = esc then
        exit;
    todosc := djanelas [i]. todosc;
if i = 0 then
        begin
        janl1 := 1;
        janl2 := 80;
        exit;
        end;
    menos := djanelas [i]. menos;
        janl1 := djanelas [i]. jax1;
        janl2 := djanelas [i]. jax2;
    end;

{--------------------------------------------------------}

{*** funcao para controlar a leitura de janela ***}

procedure LeJanela;
    var
    i : integer;

    begin
    ObtemJanela (i);
    if c3 = esc then
        exit;
    todosc := djanelas [i]. todosc;
    menos := djanelas [i]. menos;
    for linha := djanelas [i]. jay1 to djanelas [i]. jay2 do
        begin
        coluna := djanelas [i]. jax1;
        LeRestoLinha (djanelas [i]. jax2);
        if keypressed then
            begin
            todosc := salvatodosc;
            menos := salvamenos;
            exit;
            end;
        end;
    todosc := salvatodosc;
    menos := salvamenos;
    end;

{--------------------------------------------------------}

{*** funcao para fazer leitura imediata da linha anterior ***}

procedure LeituraAnt;
    label linhaanterior;
    begin
    linha := wherey;
    linhaanterior:
    dec (linha);
    if linha < 1  then
        begin sintbip;
        exit;
        end;
    coluna := 1;
    while (letela (linha, coluna) = ' ') and
       (coluna < (81)) do
        inc (coluna);
    if coluna < 81 then
        begin
        coluna := 1;
        LeRestoLinha (80);
        exit;
        end
    else if linha > 1 then
            goto linhaanterior
        else sintbip;
    end;

{--------------------------------------------------------}

{*** funcao para fazer leitura imediata da linha posterior ***}

procedure Leiturapos;
    label linhaposterior;
    begin
    linha := wherey;
    linhaposterior :
    inc (linha);
    coluna := 1;
    while (letela (linha, coluna) = ' ') and
       (coluna < (81)) do
        inc (coluna);
    if coluna < 81 then
        begin
        coluna := 1;
        LeRestoLinha (80);
        exit;
        end
    else if linha < 25 then
            goto linhaposterior
        else sintbip;
    end;

{-------------------------------------------------------}

{***  funcao para ler linha ate cursor ***}

procedure LePalavraCursor;
    begin
    coluna := wherex;
    linha := wherey;
    while (letela (linha, coluna) <> ' ') and (coluna > 1) do
        dec (coluna);
    inc (coluna);
    PalavraAtual (linha, coluna, 80);
    end;

{-------------------------------------------------------}

{***  funcao para procurar uma determinada cor de letra e fundo ***}

procedure ProcuraCor;
    begin
    if (not temletra) and (not temfundo) then
        begin
        sintsom ('vonaoass');
        exit;
        end;
    if upcase (cz) <> 'Q' then
        begin
        linha := 1;
        coluna := 1;
        end
    else begin
        linha := liant;
        coluna := coant;
        end;
    if temletra then
        begin
        while (corLetra <> leatrib (linha, coluna) and $f) and
                (linha < 26) do
            begin
            while (corLetra <> leatrib (linha, coluna) and $f) and
                (coluna < 81) do
                inc (coluna);
            if coluna > 80 then
                begin
                coluna := 1;
                inc (linha);
                end;
            end;
        end;

    if temfundo then
        begin
        while (corFundo <> (leatrib (linha, coluna) shr 4) and 7) and
                (linha < 26) do
            begin
            while (corFundo <> (leatrib (linha, coluna) shr 4) and 7) and
                    (coluna < 81) do
                inc (coluna);
            if coluna > 80 then
                begin
                coluna := 1;
                inc (linha);
                end;
            end;
        end;

    if (linha > 25) then
        begin
        sintsom ('vonaotem');
        exit;
        end
    else
        begin
        falanumeroconv (numeroparastring (linha),0);
        falanumeroconv (numeroparastring (coluna),0);
        end;


    s := '';
    if (temletra) and (temfundo) then
        begin
        while (corFundo = (leatrib (linha, coluna) shr 4) and 7) and
            (corLetra = leatrib (linha, coluna) and $f) and
            (coluna < 81) do
            begin
            s := s + letela (linha, coluna);
            inc (coluna);
            end;
        end
    else if temfundo then
            begin
            while (corFundo = (leatrib (linha, coluna) shr 4) and 7) and
                (coluna < 81) do
                begin
                s := s + letela (linha, coluna);
                inc (coluna);
                end;
            end
        else while (corLetra = leatrib (linha, coluna) and $f) and
                (linha < 81) do
                begin
                s := s+ letela (linha, coluna);
                inc (coluna);
                end;
    falastring;
    coant := coluna;
    liant := linha;
    end;

{-------------------------------------------------------}

{***  inicio ativaImediato ***}
begin
    sintinic (0, 'DIRVOX3');
    if tradinic <> 0 then
         begin
             sintbip;  sintbip;
             exit;
         end;

    cz := c3;
    lc := upcase (chr (ord(c1)+$40));   {transformei control em letra }
    c3 := lc;
        case lc of
        'L' : linhaimediato;
        'I' : EndCursorImediato;
        'A' : NovoAmbiente;
        'J' : LeJanela;
        'O' : LarguraTela;
        'U' : LeituraAnt;
        'M' : begin
                   ecoaTecla := not ecoaTecla;
                   sound (1000); delay (30); nosound;
                   if ecoaTecla then
                       begin
                            delay (30); sound (1000); delay (30); nosound;
                       end;
              end;
        'N' : leiturapos;
        'H' : FalaDataHora;
        'K' : LePalavraCursor;
        'Q' : ProcuraCor;
        'S' : BuscaString ('1');

        end;
    tradfim;
end;

end.
