{--------------------------------------------------------}
{
{   Leitor de telas 3.0 - rotinas globais
{
{   Autores: Jose' Antonio Borges
{            Xyko Goncalves (Serpro)
{
{   Baseado no programa original em assembler de
{       Orlando Jose' Rodrigues Alves
{
{   Em 24/2/97
{
{--------------------------------------------------------}

{$F+}

unit vox3glob;

interface
uses
    dos, crt,
    traduvox, intervox, sintvox, lenumstr, playvox;

function leteclado  : string;
function letela (linha, coluna: integer): char;
function maiuscAnsi (s: string): string;
function leAtrib(linha, coluna: integer): byte;
procedure pegabasehard;
procedure fala (frase : string);
procedure falastring;
procedure palavraatual (linha, coluna, fimlinha : integer);
procedure LeRestoLinha (fimlinha : integer);
procedure FalaDataHora;
procedure ObtemJanela (var i : integer);
procedure AjustaCursor;
procedure LinhaImediato;
procedure falaesq;
procedure faladir;
procedure falafonetica (letra : char);

{--------------------------------------------------------}
{               variaveis globais do vox3 ***}

type
    djanela = record
        jay1, jax1, jay2, jax2 : integer;
        todosc : boolean;
        menos : string [80];
        end;
    marca = record
        plinha, pcoluna : byte;
        end;
    captura = record
        capturado : string [80];
        end;

const
letras : array ['A'..'Z'] of string [8] =
        ('voalfa', 'vobravo', 'vocharle', 'vodelta',  'voeco',
        'vofocstr', 'vogolfe', 'vohotel', 'voindia', 'vojuliet',
        'vokilo', 'volima', 'vomaike', 'vonovemb', 'vooscar', 'vopapa',
        'voquebec', 'voromeu', 'vosierra', 'votango', 'vounifor',
        'vovictor', 'vowhiske', 'voxrrei', 'voyanke', 'vozulu');

    lixo : set of char = [#10,#176..#223];
    espacos72 : string =
    '                                                                        ';

    F1   = #59;
    F2   = #60;
    F3   = #61;
    F4   = #62;
    F5   = #63;
    F6   = #64;
    F7   = #65;
    F8   = #66;
    F9   = #67;
    F10  = #68;

    ESC  = #27;
    INS  = #82;
    DEL  = #83;
    HOME = #71;
    TEND = #79;
    PGUP = #73;
    PGDN = #81;
    CIMA = #72;
    BAIX = #80;
    ESQ  = #75;
    DIR  = #77;

    BKTAB    = #15;
    CTLENTER = #10;

    CTLPGUP = #132;
    CTLPGDN = #118;
    CTLESQ  = #115;
    CTLDIR  = #116;
    CTLHOME = #119;
    CTLEND  = #117;

    CTLF1   =  #94;
    CTLF2   =  #95;
    CTLF4   =  #97;
    CTLF5   =  #98;
    CTLF9   =  #102;
    CTLF10  =  #103;

    var
    baseHard : word;
    salvamem : array [0..3999] of byte;
    salvains, menos, salvamenos, janelamenos, salvam1 : string [80];
    exporte : text;
    dados : string;
    s : string [160];
    novoarq, linhas : string [40];
    linha, coluna, liant, coant : integer;
    todosc, salvatodosc, janelaTodosc, salvat1, ok, temletra,
                     temfundo, formatada, ansi  : boolean;
    marcas : array ['A'..'Z'] of marca;
    vetc : array [1..30] of captura;
    djanelas : array [0..9] of djanela;
    monitora : record
        plinha, pcoluna, jan : byte;
        ver : char;
        car : char;
        acao : char;
        msg : string [60];
        end;

    janpx1, janpy1, janpx2, janpy2, salvax1, salvay1, salvax2,
                    salvay2, icap, iultimo, indstring, indcarac,
        totcarac, tamstring, janl1, janl2, delibarra, quantilin,
        totcursorlinha, totcursorcoluna : byte;

    corletra, corfundo : byte;
    numjanp, numjans : byte;
    c, c2, c3, cz : char;
    ilinha, flinha, icoluna, fcoluna, salvacoluna, espera : integer;
     salvax, salvay: byte;
    lin1, lin2, col1, col2: integer;
    palavraant : string;
    regs: registers;

    ecoaTecla, leitRapida, leitCondens: boolean;
    vertical: boolean;
    veloAtual: char;

implementation

{--------------------------------------------------------}

{*** funcao para ler um string apartir do teclado ***}

function leteclado  : string;
var
    i: integer;
    teclas : string[80];

begin
    teclas := '';
    i := 1;
    repeat
        regs.ax := 0;
        intr ($16, regs);
        c3  := chr (regs.ax and $ff);

        case c3 of
        #0 : begin
            sintsom ('votecinv');
            end;
        #8 : begin
            dec (i);
            if i < 1 then
                sintbip
            else begin
                sintcarac (teclas[i]);
                teclas := copy (teclas, 1, (i -1));
                end;
            end;
        esc : begin
            sintsom ('voanulad');
            teclas := '';
            end;
        else if c3 <> #13 then
                begin
                sintcarac (c3);
                        teclas := teclas + c3;
                inc (i);
                end;
            end;
    until (c3 = #13) or (c3 = esc) or (i > 80);
    leteclado := teclas;
    end;

    {--------------------------------------------------------}

{*** recupera um caracter do buffer de tela *** }

    function letela (linha, coluna: integer): char;
    begin
        letela := chr (mem [baseHard: (linha-1) * 160 + (coluna-1) * 2]);
    end;

{--------------------------------------------------------}

{*** forca string maiuscula ***}

function maiuscAnsi (s: string): string;
var x: string;
    i: integer;
begin
    x := s;
    for i:= 1 to length (s) do
        if x[i] in ['a'..'z'] then
            x[i] := upcase (x[i])
        else
            if x[i] in [#$e0..#$ff] then
                x[i] := chr (ord(x[i]) - $20);
    maiuscAnsi := x;
end;

    {--------------------------------------------------------}

    function leAtrib(linha, coluna: integer): byte;
    begin
        leAtrib := mem [baseHard: (linha-1) * 160 + (coluna-1) * 2 + 1];
    end;

    {-----------------------------------#---------------------}

    procedure pegaBaseHard;
    begin
        baseHard := $b800;
        s := ' ';
        s := sintAmbiente ('VIDEO');
        cz := upcase (s[1]);
        if (cz = 'H') or (cz = 'M') then baseHard := $b000;
    end;

    {--------------------------------------------------------}

{ *** funcao para falar caracter em fonetica internacional *** }

procedure falafonetica (letra : char);
    begin
    case letra of
    'a'..'z', 'A'..'Z' : begin
        letra := upcase (letra);
        sintsom (letras [letra]);
        end;
    else sintcarac (letra);
        end;
    end;

{------------------------------------------------------}

{ *** funcao para falar seta para esquerda ***}

procedure falaesq;
    begin
    if coluna > janpx1 then
        begin
        sintcarac (letela (linha, coluna-1));
        dec (coluna);
        end
    else begin
        sintBip;
        coluna := janpx1;
        end;
    end;

    {--------------------------------------------------------}

{ *** funcao para falar seta para direita ***}

procedure faladir;
    begin
    if coluna < janpx2 then
        begin
        sintcarac (letela (linha, coluna));
        inc (coluna);
        end
    else begin
        sintBip;
        coluna := janpx2;
        end;
    end;

    {--------------------------------------------------------}

{ *** funcao para ajustar cursor ***}

procedure AjustaCursor;
    begin
    if linha < janpy1 then
        linha := janpy1;
if coluna < janpx1 then
        coluna := janpx1;
if linha > janpy2 then
        linha := janpy2;
if coluna > janpx2 then
        coluna := janpx2;
    end;

{-------------------------------------------------------}

{*** funcao para falar data ou hora ***}

procedure FalaDataHora;
    var
    hh, mm, ss, ce,   dia, mes, ano, diasem  : word;

    begin
if upcase (cz) = 'H' then
        begin
    getdate (ano, mes, dia, diasem);
        falanumeroconv (numeroparastring (dia),0);
        falanumeroconv (numeroparastring (mes),0);
        falanumeroconv (numeroparastring (ano - 1900),0);
        c := ' ';
        c3 := ' ';
        end
    else begin
        gettime (hh, mm, ss, ce);
        if (hh = 1) or (hh = 2) or (hh = 21) or (hh = 22) then
        falanumeroconv (numeroparastring (hh),1)
        else falanumeroconv (numeroparastring (hh),0);
        falanumeroconv (numeroparastring (mm),0);
        falanumeroconv (numeroparastring (ss),0);

        end;
    end;

{------------------------------------------------------}

{***  funcao para fazer leitura imediata da linha corrente ***}

procedure linhaimediato;
    begin
    linha := wherey;
    coluna := 1;
    LeRestoLinha (80);
    end;

    {--------------------------------------------------------}

{ *** funcao para falar  strings *** }

procedure fala (frase : string);
var
   compila : string;
begin
   compilafonemas (frase, compila);
   falafonemas (compila, true);
end;

    {--------------------------------------------------------}

{ *** funcao para falar palavra atual ***}

procedure FalaString;
    const
    numerico : set of char = ['0'..'9'];

    var
    inicpedaco, limite,  repetido,salvarep, salvanum, posc, coluna : integer;
    valor : longint;
    letras, ss, numeros : string [80];
    carater : char;

    begin
    ss:= s;
    coluna := 1;
    limite := (length (ss) +1);
    while coluna < limite do
        begin
        if not todosc then
            begin
            posc := 1;
            while (menos [posc] <> ss [coluna]) and
                    (posc <= length (menos)) do
                inc (posc);
            if ss [coluna] = menos [posc] then
                ss [coluna] := ' ';
            end;
        if ss [coluna] in lixo then
            ss [coluna] := ' ';
        inc (coluna);
        end;

    ss := ss + #$ff + #$ff + #$ff;
    inicpedaco := 1;
    coluna := 1;
    repeat
        carater := ss[coluna];
        inc (coluna);
        repetido := 1;
        letras := '';
        numeros := '';
        while (carater = ss [coluna]) and (coluna < limite) do
            begin
            inc (repetido);
            inc (coluna);
            end;
        salvarep := coluna;

        coluna := inicpedaco;
        while (ss [coluna] in numerico) and (coluna < limite) do
            begin
            numeros := numeros + ss [coluna];
            inc (coluna);
            end;
        salvanum := coluna;

        coluna := inicpedaco;
        while ((ss [coluna] <> ss[coluna + 1]) or
               (ss [coluna] <> ss[coluna + 2]) or
               (ss [coluna] <> ss[coluna + 3])) and
                      (not (ss [coluna] in numerico)) and
                      (coluna < limite) do
            begin
            letras := letras + ss [coluna];
            inc (coluna);
            end;

        if numeros <> '' then
            begin
            if (repetido > 3) and
                ((carater = '0') or (repetido > 9)) then
                begin
                sintsom ('vopin');
                falaNumeroConv (numeroparastring(repetido),0);
                sintcarac (carater);
                coluna :=salvarep;
                inicpedaco := salvarep;
                end
            else if length (numeros) < 10 then
                    begin
                    while (numeros <> '') and (numeros [1] = '0') do
                        begin
                            falaNumeroConv (numeroParaString (0), 0);
                            delete (numeros, 1, 1);
                        end;
                    if numeros <> '' then
                        begin
                        posc := 0;
                        val (numeros, valor, posc);
                        falanumeroconv (numeroparastring(valor),0);
                        end;
                        inicpedaco := salvanum;
                        coluna := salvanum;
                    end
                else begin
                    fala (numeros);
                    inicpedaco := salvanum;
                    coluna :=salvanum;
                    end;
            end
        else if repetido > 3 then
                begin
                coluna := salvarep;
                inicpedaco := coluna;
                if carater <> ' ' then
                    begin
                    sintsom ('vopin');
                    falanumeroconv (numeroparastring (repetido),0);
                    sintcarac (carater);
                end;
                    end
            else begin
                fala (letras);
                inicpedaco := coluna;
                end;

    until coluna = limite;
    end;

    {--------------------------------------------------------}

{ *** funcao para falar palavra atual ***}

procedure palavraatual (linha, coluna, fimlinha : integer);
    begin
    s := '';
    while (letela (linha, coluna) <> ' ') and (coluna < (fimlinha + 1)) do
        begin
                 s := s + letela (linha, coluna);
             inc (coluna);
        end;

    if s = '' then
        begin
        sintsom ('vonada');
        exit;
        end;
    FalaString;
end;

    {--------------------------------------------------------}

{ *** funcao para ler palavras na linha ***}

procedure LeRestoLinha (fimlinha : integer);
    begin
    repeat
        while (letela (linha, coluna) = ' ') and
       (coluna < (fimlinha +1)) do
            inc (coluna);
        if coluna < (fimlinha +1) then
            palavraatual (linha, coluna, fimlinha)
        else sintclek;
        if keypressed then
            exit;
       { coluna := coluna + length (s);}
        while (letela (linha, coluna) <> ' ') and (coluna
        <     fimlinha +1) do
            inc (coluna);
    until coluna > fimlinha;
    end;

{--------------------------------------------------------}

{*** funcao para obter uma janela ***}

procedure ObtemJanela (var i : integer);
    label OutraVez;

begin
    sintsom ('vojanela');
    OutraVez:
        regs.ax := 0;
        intr ($16, regs);
        c3  := chr (regs.ax and $ff);
        case c3 of
        #0 : begin
            sintsom ('votecinv');
            goto OutraVez;
            end;
            esc : begin
            sintsom ('voanulad');
            exit;
            end;
        '0'..'9' : begin
            sintcarac (c3);
        i := (ord (c3) - ord ('0'));
        end;
        else begin
            sintsom ('votecinv');
            goto OutraVez;
            end;
        end;

    if (djanelas [i]. jay1 = 0) or (djanelas [i]. jax1 = 0) or
       (djanelas [i]. jay2 = 0) or (djanelas [i]. jax2 = 0) then
        begin
        sintsom ('vonaoass');
        c3 := esc;
        exit;
        end;
    end;

{--------------------------------------------------------}
{             transforma caracteres para ANSI
{--------------------------------------------------------}

function charANSI (c: char): char;
begin
    case c of
        '': c:= #$E1;
        '': c:= #$E9;
        '': c:= #$ED;
        '': c:= #$F3;
        '': c:= #$FA;
        '': c:= #$C1;
        '': c:= #$C9;
        '': c:= #$CD;
        '': c:= #$D3;
        '': c:= #$DA;
        '': c:= #$E2;
        '': c:= #$EA;
        '': c:= #$F4;
        '': c:= #$C2;
        '': c:= #$CA;
        '': c:= #$D4;
        '': c:= #$E3;
        '': c:= #$F5;
        '': c:= #$C3;
        '': c:= #$D5;
        '': c:= #$E0;
        '': c:= #$C0;
        '': c:= #$FC;
        '': c:= #$DC;
        '': c:= #$E7;
        '': c:= #$C7;
    end;
    charAnsi := c;
end;

begin
    janpy1 := 1;
    janpx1 := 1;
    janpy2 := 25;
    janpx2 := 80;
    janl1 := 1;
    janl2 := 80;
    icap := 0;
    iultimo := 0;
    indstring := 0;
    tamstring := 0;
    espera := 0;
    formatada := false;

    ecoaTecla := true;
    leitRapida := true;
    leitCondens := false;
    vertical := false;
    veloAtual := '3';

end.
