{--------------------------------------------------------}

{   Leitor de telas 3.0 - rotinas de controle de janelas
{   Autores: Jose' Antonio Borges
{            Xyko Goncalves (Serpro)
{
{
{   Em 13/6/97
{
{--------------------------------------------------------}

{$F+}

unit vox3jan;

interface
uses
    dos, crt,
    traduvox, intervox, sintvox, lenumstr, playvox,vox3glob, vox3amb;

procedure GuardaJanela (linha, coluna : integer);
procedure recuperaJanela;

implementation

    var
    erro : integer;
    temjanela : boolean;
    janguardada : text;
    janelas : string;

function ExisteArq (nomearq: string): boolean;
var existe: boolean;
    arq: file;
begin
    assign (arq, nomearq);
    {$I-}  reset (arq); {$i+}
    existe := ioresult = 0;
    if existe then close (arq);
    existeArq := existe;
end;

{------------------------------------------------------}

{*** funcao para formatar uma janela escolhida **}

procedure FormataJanela;
    var
    poscol, tamlin : byte;

    begin
        if (janelas = '0.jan') or (janelas = '10.jan') then
        begin
        sintsom ('voanulad');
        exit;
        end;

    assign (janguardada, janelas);
    {$i-} reset (janguardada); {$i+}
    if ioresult <> 0 then
        begin
        FalaErro (93);
        exit;
        end;

    readln (janguardada, s);
    salvay1 := janpy1;
    salvax1 := janpx1;
    salvay2 := janpy2;
    salvax2 := janpx2;
    move (mem [basehard : 0], salvamem, 4000);

    readln (janguardada, janpy1, janpx1, janpy2, janpx2, s);
    if copy (s, 1, 1) = 'N' then
        begin
        todosc := false;
        menos := copy (s, 2, (length (s) -1));
        end
    else todosc := true;
    formatada := true;
    poscol := (janpx1 -1) *2;
    tamlin := (janpx2 +1) - janpx1;
    for linha := janpy1 to janpy2 do
        begin
        readln (janguardada, s);
        move (s[1], mem [basehard : ((linha -1) *160) + poscol], tamlin);
        end;
    coluna := janpx1;
    linha := janpy1;
    close (janguardada);
    sintclek;
    end;

{------------------------------------------------------}

{*** funcao para falar comentario da janela ***}

procedure FalaComentario;
    begin
    assign (janguardada, janelas);
    {$i-} reset (janguardada); {$i+}
    if ioresult <> 0 then
        begin
        FalaErro (92);
        exit;
        end;

    readln (janguardada, s);
    close (janguardada);
    FalaString;
    end;

{------------------------------------------------------}

{*** funcao para procurar janela anterior ***}

procedure ProcuraAcima;
    var i : integer;

    begin
    val (copy (janelas, 1, 1), i, erro);
    if erro <> 0 then
        begin
        FalaErro (98);
        exit;
        end;
    temjanela := false;
    while (not temjanela) and (i > 0) do
        begin
        dec (i);
        str (i, janelas);
        janelas := janelas + '.jan';
    temjanela := ExisteArq (janelas);
        end;
    if i = 0 then
        begin
        sintsom ('voultimo');
        janelas := '0.jan';
        exit;
        end;
    FalaComentario;
    end;

{------------------------------------------------------}

{*** funcao para procurar janela posterior ***}

procedure ProcuraAbaixo;
    var i, salvai : integer;

    begin
    val (copy (janelas, 1, 1), i, erro);
    if erro <> 0 then
        begin
        FalaErro (98);
        exit;
        end;
    salvai := i;
    temjanela := false;
    while (not temjanela) and (i < 10) do
        begin
        inc (i);
        str (i, janelas);
        janelas := janelas + '.jan';
    temjanela := ExisteArq (janelas);
        end;
    if temjanela then
        begin
        FalaComentario;
        exit;
        end;
    sintsom ('voultimo');
    i := salvai;
    str (i, janelas);
    janelas := janelas + '.jan';
    end;

{------------------------------------------------------}

{*** funcao para guardar uma janela num arquivo "n.jan" ***}

procedure GuardaJanela (linha, coluna : integer);
    var i : integer;

    begin
    i:= 0;
    temjanela := true;
    while temjanela do
        begin
        inc (i);
        str (i, janelas);
        janelas := janelas + '.jan';
        temjanela := ExisteArq (janelas);
        end;

    if i > 9 then
        begin
        sintsom ('vooverfl');
        janelas := '9.jan';
        exit;
        end;

    sintsom ('vocoment');
    s := leteclado;
    if c3 = esc then
        exit;

    assign (janguardada, janelas);
    {$i-} rewrite (janguardada); {$i+}
    if ioresult <> 0 then
        begin
        FalaErro (92);
        exit;
        end;

    if (c3 = #13) and (s <> '') then
        writeln (janguardada, s)
    else writeln (janguardada, 'janela', ' ', i);
    if janelatodosc then
        s := 's' 
    else s := 'n' + janelamenos;

    writeln (janguardada, janpy1, ' ', janpx1, ' ', janpy2, ' ', janpx2, ' ',
                s);

    for linha := janpy1 to janpy2 do
        begin
        s := '';
        for coluna := janpx1 to janpx2 do
            begin
            s := s + letela (linha, coluna);
            s := s + chr (leatrib (linha, coluna));
            end;
        writeln (janguardada, s);
        end;
        sintclek;
    close (janguardada);
    end;

{------------------------------------------------------}

{*** funcao para recuperar uma janela num arquivo "n.jan" ***}

procedure RecuperaJanela;
    var
    i : integer;
    primeiravez :  boolean;

    begin
    i:= 0;
    primeiravez := true;
    temjanela := false;
    while (not temjanela) and (i < 10) do
        begin
        inc (i);
        str (i, janelas);
        janelas := janelas + '.jan';
        temjanela := ExisteArq (janelas);
        end;

    if not temjanela then
        begin
        sintsom ('vonaotem');
        exit;
        end;

    sintsom ('vojanela');
    repeat
        regs.ax := 0;
        intr ($16, regs);
        c := chr (regs.ax and $ff);
        c2 := chr (regs.ax shr 8);
        case c of
        #$0: begin
            case c2 of
            cima : ProcuraAcima;
            baix : begin
                if primeiravez then
                    begin
                    primeiravez := false;
                    janelas := '0.jan';
                    end;
                procuraabaixo;
                end;
            else sintsom ('votecinv');
            end;
            end;

        '0'..'9' : begin
            sintcarac (c);
            janelas := c + '.jan';
            temjanela := ExisteArq (janelas);
            if temjanela then
                begin
                FormataJanela;
                exit;
                end
            else begin
                sintsom ('vonaotem');
                exit;
                end;
            end;
        #13 : begin
            formatajanela;
            c := ' ';
            exit;
            end;
        esc : begin
            sintsom ('voanulad');
            c := ' ';
            exit;
            end;

        else sintsom ('votecinv');
        end;
    until (c = #13) or (c = esc);
    c := ' ';
    end;

    end.
